
function [error] = optimiseFun_OFF(parms, FR, OffOcc, medOff, N, A)

% Upack parms
alpha = parms(1);
beta = parms(2);
S0 = parms(3);
Smax = parms(4);
Smin = parms(5);

% S model
Tmax = 43200;
S = zeros(1,Tmax);
S(1) = S0;
for t=2:Tmax
    dSdt(t) = alpha*FR(t)*(Smax - S(t-1)) - beta*(S(t-1) - Smin)*OffOcc(t); 
    S(t) = S(t-1) + dSdt(t);
end

% Error
[medProcS, durN] = medianBoutNREM(S, N, A);
durN(durN<=15) =[];
w = durN/sum(durN);
error = sum(abs(medOff(:,2) - medProcS(:,2)) .*w');

end 